/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.screen.util;

import fi.dy.masa.malilib.config.interfaces.ConfigType;
import fi.dy.masa.malilib.config.interfaces.IConfigDisplay;
import fi.dy.masa.malilib.config.options.ConfigBase;
import fi.dy.masa.malilib.config.options.ConfigEnum;
import fi.dy.masa.malilib.gui.button.interfaces.IButtonPeriodic;
import fi.dy.masa.malilib.gui.screen.util.ConfigItem;
import fi.dy.masa.malilib.gui.screen.util.ScreenConstants;
import fi.dy.masa.malilib.util.RenderUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.EnumChatFormatting;
import net.minecraft.GuiButton;
import net.minecraft.GuiScreen;
import net.minecraft.I18n;

class ConfigItemPeriodic<T extends ConfigBase<T> & IConfigDisplay>
extends ConfigItem<T> {
    final IButtonPeriodic periodicButton;
    List<String> strings = new ArrayList<String>();
    boolean drawComment = false;

    public ConfigItemPeriodic(int index, T config, GuiScreen screen) {
        super(index, config, screen);
        if (((ConfigBase)config).getType() == ConfigType.ENUM) {
            this.drawComment = true;
            this.strings.add(I18n.getString((String)"manyLib.gui.comment.available_values") + ":");
            for (Enum allEnumValue : ((ConfigEnum)config).getAllEnumValues()) {
                this.strings.add(StringUtils.getTranslatedOrFallback("config.enum." + ((ConfigBase)config).getName() + "." + allEnumValue.name(), allEnumValue.name()));
            }
        }
        this.periodicButton = ScreenConstants.getPeriodicButton(index, config, screen);
        this.buttons.add((GuiButton)this.periodicButton);
    }

    @Override
    public void tryDrawComment(GuiScreen guiScreen, int x, int y) {
        super.tryDrawComment(guiScreen, x, y);
        if (this.drawComment && ((GuiButton)this.periodicButton).func_82252_a()) {
            int ordinal = ((ConfigEnum)this.config).getOrdinal() + 1;
            String s = this.strings.get(ordinal);
            this.strings.set(ordinal, EnumChatFormatting.GREEN + s);
            RenderUtils.drawTextList(guiScreen, this.strings, x, y);
            this.strings.set(ordinal, s);
        }
    }

    @Override
    public void customDraw(GuiScreen guiScreen, int x, int y) {
    }

    @Override
    public void customMouseClicked(GuiScreen guiScreen, int mouseX, int mouseY, int click) {
    }

    @Override
    public void customActionPerformed(GuiButton guiButton) {
        if (guiButton == this.periodicButton) {
            this.periodicButton.next();
        }
    }

    @Override
    public void customSetVisible(boolean visible) {
    }

    @Override
    public void resetButtonClicked() {
        this.periodicButton.updateString();
    }
}

