/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.screen.util;

import fi.dy.masa.malilib.config.interfaces.ConfigType;
import fi.dy.masa.malilib.config.options.ConfigBase;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigColor;
import fi.dy.masa.malilib.config.options.ConfigDouble;
import fi.dy.masa.malilib.config.options.ConfigEnum;
import fi.dy.masa.malilib.config.options.ConfigInteger;
import fi.dy.masa.malilib.config.options.ConfigString;
import fi.dy.masa.malilib.gui.button.ResetButton;
import fi.dy.masa.malilib.gui.button.interfaces.CommentedText;
import fi.dy.masa.malilib.gui.button.interfaces.IInteractiveElement;
import fi.dy.masa.malilib.gui.button.interfaces.ISuppressibleElement;
import fi.dy.masa.malilib.gui.screen.util.ConfigItemColor;
import fi.dy.masa.malilib.gui.screen.util.ConfigItemInputBox;
import fi.dy.masa.malilib.gui.screen.util.ConfigItemPeriodic;
import fi.dy.masa.malilib.gui.screen.util.ConfigItemSlideable;
import fi.dy.masa.malilib.gui.screen.util.ScreenConstants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.GuiButton;
import net.minecraft.GuiScreen;
import net.minecraft.Minecraft;

public abstract class ConfigItem<T extends ConfigBase<?>>
implements IInteractiveElement,
ISuppressibleElement {
    final T config;
    final ResetButton resetButton;
    final CommentedText commentedText;
    boolean visible;
    final List<GuiButton> buttons = new ArrayList<GuiButton>();
    final GuiScreen screen;

    public ConfigItem(int index, T config, GuiScreen screen) {
        this.config = config;
        this.screen = screen;
        this.resetButton = ScreenConstants.getResetButton(index, screen);
        this.commentedText = ScreenConstants.getCommentedText(index, config, screen);
        this.buttons.add(this.resetButton);
    }

    public void draw(GuiScreen guiScreen, int x, int y) {
        if (this.visible) {
            this.commentedText.draw(guiScreen, x, y);
            this.buttons.forEach(guiButton -> guiButton.drawButton(guiScreen.mc, x, y));
            this.customDraw(guiScreen, x, y);
        }
    }

    public void tryDrawComment(GuiScreen guiScreen, int x, int y) {
        this.commentedText.tryDrawComment(guiScreen, x, y);
        this.resetButton.tryDrawComment(guiScreen, x, y);
    }

    public abstract void customDraw(GuiScreen var1, int var2, int var3);

    @Override
    public void mouseClicked(int mouseX, int mouseY, int click) {
        if (click == 0) {
            this.buttons.forEach(guiButton -> this.buttonListen((GuiButton)guiButton, this.screen, mouseX, mouseY));
        }
        this.customMouseClicked(this.screen, mouseX, mouseY, click);
    }

    public abstract void customMouseClicked(GuiScreen var1, int var2, int var3, int var4);

    public void buttonListen(GuiButton guiButton, GuiScreen guiScreen, int mouseX, int mouseY) {
        if (guiButton.mousePressed(guiScreen.mc, mouseX, mouseY)) {
            guiScreen.selectedButton = guiButton;
            guiButton.playClickedSound(guiScreen.mc.sndManager);
            this.actionPerformed(guiButton);
        }
    }

    @Override
    public void updateScreen() {
        this.resetButton.enabled = this.config.isModified();
    }

    public void actionPerformed(GuiButton guiButton) {
        if (guiButton == this.resetButton) {
            this.config.resetToDefault();
            this.resetButtonClicked();
        }
        this.customActionPerformed(guiButton);
    }

    @Override
    public void keyTyped(char c, int i) {
    }

    public abstract void resetButtonClicked();

    public abstract void customActionPerformed(GuiButton var1);

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        this.buttons.forEach(guiButton -> {
            guiButton.drawButton = visible;
        });
        this.commentedText.setVisible(visible);
        this.customSetVisible(visible);
    }

    public abstract void customSetVisible(boolean var1);

    public static ConfigItem<?> getConfigItem(int index, ConfigBase<?> config, GuiScreen screen) {
        return switch (config.getType()) {
            case ConfigType.DOUBLE -> new ConfigItemSlideable<ConfigDouble>(index, (ConfigDouble)config, screen);
            case ConfigType.BOOLEAN -> new ConfigItemPeriodic<ConfigBoolean>(index, (ConfigBoolean)config, screen);
            case ConfigType.INTEGER -> new ConfigItemSlideable<ConfigInteger>(index, (ConfigInteger)config, screen);
            case ConfigType.STRING -> new ConfigItemInputBox<ConfigString>(index, (ConfigString)config, screen);
            case ConfigType.ENUM -> new ConfigItemPeriodic<ConfigEnum>(index, (ConfigEnum)config, screen);
            case ConfigType.COLOR -> new ConfigItemColor(index, (ConfigColor)config, screen);
            default -> {
                Minecraft.setErrorMessage((String)"unsupported config type");
                yield null;
            }
        };
    }
}

