/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.screen;

import fi.dy.masa.malilib.ManyLib;
import fi.dy.masa.malilib.config.ConfigTab;
import fi.dy.masa.malilib.config.interfaces.IConfigHandler;
import fi.dy.masa.malilib.config.interfaces.IConfigResettable;
import fi.dy.masa.malilib.config.options.ConfigEnum;
import fi.dy.masa.malilib.gui.button.PullDownButton;
import fi.dy.masa.malilib.gui.button.ScrollBar;
import fi.dy.masa.malilib.gui.button.SearchField;
import fi.dy.masa.malilib.gui.button.interfaces.IButtonPeriodic;
import fi.dy.masa.malilib.gui.button.interfaces.ICommentedElement;
import fi.dy.masa.malilib.gui.screen.interfaces.AboutInputMethod;
import fi.dy.masa.malilib.gui.screen.interfaces.GuiScreenParented;
import fi.dy.masa.malilib.gui.screen.interfaces.SearchableScreen;
import fi.dy.masa.malilib.gui.screen.interfaces.StatusScreen;
import fi.dy.masa.malilib.gui.screen.util.ConfigItem;
import fi.dy.masa.malilib.gui.screen.util.ScreenConstants;
import fi.dy.masa.malilib.gui.screen.util.SortCategory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.GuiButton;
import net.minecraft.GuiScreen;
import net.minecraft.GuiYesNoMITE;
import net.minecraft.I18n;
import net.minecraft.MathHelper;
import org.lwjgl.input.Keyboard;

public class ValueScreen
extends GuiScreenParented
implements SearchableScreen,
StatusScreen {
    private final IConfigHandler configInstance;
    private final List<ConfigTab> configTabs;
    private ConfigTab currentTab;
    private int currentTabIndex;
    private final Map<Integer, GuiButton> buttonMap = new HashMap<Integer, GuiButton>();
    private final List<ConfigItem<?>> configItems = new ArrayList();
    private SearchField searchField;
    private ScrollBar scrollBar;
    private PullDownButton pullDownButton;
    private int status;
    private int maxStatus;
    private boolean singlePage;
    private boolean needInit;
    private final ConfigEnum<SortCategory> sortCategory = new ConfigEnum<SortCategory>("manyLib.sortCategory", SortCategory.Default);

    public ValueScreen(GuiScreen parentScreen, String screenTitle, IConfigHandler configInstance) {
        super(parentScreen, screenTitle);
        this.configInstance = configInstance;
        this.configTabs = configInstance.getConfigTabs();
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void initGui() {
        this.putButtons();
        this.setCurrentTab(this.currentTabIndex);
        this.updateConfigItemsAfterTabChange();
    }

    private void putButtons() {
        this.buttonMap.clear();
        int buttonX = 20;
        for (int index = 0; index < this.configTabs.size(); ++index) {
            ConfigTab configTab = this.configTabs.get(index);
            String name = configTab.getGuiDisplayName();
            int stringWidth = this.fontRenderer.getStringWidth(name);
            this.buttonMap.put(index, new GuiButton(index, buttonX, 30, stringWidth + 10, 20, name));
            buttonX += stringWidth + 14;
        }
        this.buttonMap.put(201, ScreenConstants.getResetAllButton(buttonX));
        this.buttonMap.put(202, ScreenConstants.getSortButton(buttonX, this.sortCategory));
        this.searchField = ScreenConstants.getSearchButton(this);
        this.buttonMap.put(204, this.searchField);
        this.scrollBar = ScreenConstants.getScrollBar(this, 7, 0);
        this.buttonMap.put(203, this.scrollBar);
        this.pullDownButton = ScreenConstants.getPullDownButton(this);
        this.buttonMap.put(205, this.pullDownButton);
        this.buttonMap.get((Object)Integer.valueOf((int)205)).drawButton = false;
    }

    private void updateConfigItems() {
        this.configItems.clear();
        for (int i = this.status; i < this.currentTab.getSearchableConfigSize() && i < this.status + 7; ++i) {
            ConfigItem<?> configItem = ConfigItem.getConfigItem(i - this.status, this.currentTab.getSearchableConfig(i), this);
            configItem.setVisible(true);
            this.configItems.add(configItem);
        }
    }

    private void updateConfigItemsAfterTabChange() {
        this.status = 0;
        this.maxStatus = this.currentTab.getMaxStatusForScreen(7);
        this.singlePage = this.currentTab.getSearchableConfigSize() <= 7;
        this.scrollBar.drawButton = !this.singlePage;
        this.scrollBar.updateArguments(7, this.currentTab.getSearchableConfigSize());
        this.updateConfigItems();
    }

    @Override
    public void drawScreen(int i, int j, float f) {
        this.drawDefaultBackground();
        this.drawString(this.fontRenderer, this.screenTitle, 40, 15, 0xFFFFFF);
        this.buttonMap.values().forEach(guiButton -> guiButton.drawButton(this.mc, i, j));
        this.getConfigItems().forEach(configItem -> configItem.draw(this, i, j));
        this.buttonMap.values().stream().filter(guiButton -> guiButton instanceof ICommentedElement).map(guiButton -> (ICommentedElement)guiButton).anyMatch(iCommentedElement -> iCommentedElement.tryDrawComment(this, i, j));
        this.getConfigItems().forEach(configItem -> configItem.tryDrawComment(this, i, j));
    }

    public void updateScreen() {
        super.updateScreen();
        if (!this.singlePage) {
            this.wheelListener();
        }
        this.getConfigItems().forEach(ConfigItem::updateScreen);
        this.buttonMap.get((Object)Integer.valueOf((int)201)).enabled = this.currentTab.getAllConfigs().stream().anyMatch(IConfigResettable::isModified);
        this.searchField.updateScreen();
    }

    @Override
    public void setStatus(int status) {
        this.status = MathHelper.clamp_int((int)status, (int)0, (int)this.maxStatus);
        this.updateConfigItems();
        if (!this.singlePage) {
            if (this.scrollBar == null) {
                ManyLib.logger.error("ValueScreen: multiPaged but no scroll bar?\n" + this);
            } else {
                this.scrollBar.updateRatioByScreen(this.status);
            }
        }
        this.updateScreen();
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public int getMaxStatus() {
        return this.maxStatus;
    }

    @Override
    public void scroll(boolean isScrollDown) {
        if (isScrollDown) {
            if (this.status + 7 < this.currentTab.getSearchableConfigSize()) {
                this.addStatus(3);
            }
        } else if (this.status > 0) {
            this.addStatus(-3);
        }
    }

    protected void mouseClicked(int mouseX, int mouseY, int click) {
        this.searchField.mouseClicked(mouseX, mouseY, click);
        if (click == 0) {
            this.buttonMap.values().stream().filter(x -> x.mousePressed(this.mc, mouseX, mouseY)).forEach(guiButton -> {
                this.selectedButton = guiButton;
                guiButton.playClickedSound(this.mc.sndManager);
                this.actionPerformed((GuiButton)guiButton);
            });
        }
        this.getConfigItems().forEach(configItem -> configItem.mouseClicked(mouseX, mouseY, click));
        this.pullDownButton.mouseClicked(mouseX, mouseY, click);
        this.getConfigItems().filter(configItem -> configItem instanceof AboutInputMethod).map(configItem -> (AboutInputMethod)((Object)configItem)).anyMatch(aboutInputMethod -> aboutInputMethod.tryActivateIM(mouseX, mouseY, click));
        if (this.needInit) {
            this.needInit = false;
            this.initGui();
        }
    }

    protected void actionPerformed(GuiButton guiButton) {
        if (!guiButton.drawButton) {
            return;
        }
        int id = guiButton.id;
        switch (id) {
            case 201: {
                String question = I18n.getString((String)"manyLib.gui.reset_tab_question");
                String yes = I18n.getString((String)"gui.yes");
                String no = I18n.getString((String)"gui.no");
                GuiYesNoMITE var3 = new GuiYesNoMITE((GuiScreen)this, question, this.configInstance.getName(), yes, no, 0);
                this.mc.displayGuiScreen((GuiScreen)var3);
                break;
            }
            case 202: {
                ((IButtonPeriodic)this.buttonMap.get(202)).next();
                this.sort();
                break;
            }
            case 204: {
                this.searchField.toggle();
                break;
            }
            case 205: {
                this.pullDownButton.toggle();
                break;
            }
            default: {
                if (id >= 200) break;
                this.needInit = true;
                this.setCurrentTab(id);
            }
        }
    }

    public void confirmClicked(boolean result, int flag) {
        if (result && flag == 0) {
            this.currentTab.getAllConfigs().forEach(IConfigResettable::resetToDefault);
        }
        this.mc.displayGuiScreen((GuiScreen)this);
    }

    @Override
    protected void keyTyped(char c, int i) {
        this.getConfigItems().forEach(configItem -> configItem.keyTyped(c, i));
        this.searchField.keyTyped(c, i);
        super.keyTyped(c, i);
    }

    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
        this.configInstance.save();
    }

    private Stream<ConfigItem<?>> getConfigItems() {
        return this.configItems.stream();
    }

    private void setCurrentTab(int index) {
        this.buttonMap.get((Object)Integer.valueOf((int)this.currentTabIndex)).enabled = true;
        this.currentTabIndex = index;
        this.currentTab = this.configTabs.get(index);
        this.buttonMap.get((Object)Integer.valueOf((int)index)).enabled = false;
    }

    public String toString() {
        return "Config Instance: " + this.configInstance.getName() + "\nTab: " + this.currentTab.getUnlocalizedName() + "\nSingle Paged: " + this.singlePage + "\nStatus: " + this.status;
    }

    private void sort() {
        this.currentTab.sort((SortCategory)((Object)this.sortCategory.getEnumValue()));
        this.status = 0;
        this.updateConfigItems();
    }

    @Override
    public void updateSearchResult(String input) {
        this.currentTab.updateSearchableConfigs(input);
        this.updateConfigItemsAfterTabChange();
    }

    @Override
    public void resetSearchResult() {
        this.currentTab.resetSearchableConfigs();
        this.updateConfigItemsAfterTabChange();
    }
}

