/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.button;

import fi.dy.masa.malilib.ManyLib;
import fi.dy.masa.malilib.config.interfaces.ConfigType;
import fi.dy.masa.malilib.config.interfaces.IStringRepresentable;
import fi.dy.masa.malilib.config.interfaces.IStringValue;
import fi.dy.masa.malilib.config.options.ConfigBase;
import fi.dy.masa.malilib.config.options.ConfigDouble;
import fi.dy.masa.malilib.gui.button.interfaces.ICommentedElement;
import fi.dy.masa.malilib.gui.button.interfaces.IInteractiveElement;
import fi.dy.masa.malilib.gui.button.interfaces.ISuppressibleElement;
import net.minecraft.FontRenderer;
import net.minecraft.GuiTextField;
import org.jetbrains.annotations.Nullable;

public class InputBox<T extends ConfigBase<?>>
implements ICommentedElement,
IInteractiveElement,
ISuppressibleElement {
    protected final T config;
    protected final int x;
    protected final int y;
    protected final GuiTextField guiTextField;
    protected boolean mouseOver;

    public InputBox(T config, FontRenderer fontRenderer, int x, int y, int width, int height) {
        this.config = config;
        this.x = x;
        this.y = y;
        this.guiTextField = new GuiTextField(fontRenderer, x, y, width, height);
        this.setTextByValue();
    }

    @Override
    public void keyTyped(char c, int i) {
        if (this.guiTextField.isFocused()) {
            this.guiTextField.textboxKeyTyped(c, i);
            if (i == 1 || i == 28 || i == 156) {
                this.setValueByText();
                this.guiTextField.setFocused(false);
            }
        }
    }

    @Override
    public void updateScreen() {
        this.guiTextField.updateCursorCounter();
    }

    @Override
    public void mouseClicked(int par1, int par2, int par3) {
        GuiTextField guiTextField = this.guiTextField;
        if (guiTextField.isFocused()) {
            guiTextField.mouseClicked(par1, par2, par3);
            if (!guiTextField.isFocused()) {
                this.setValueByText();
            }
        } else {
            guiTextField.mouseClicked(par1, par2, par3);
        }
    }

    public boolean tryActivateIM(int par1, int par2, int par3) {
        if (this.guiTextField.isFocused()) {
            this.guiTextField.mouseClicked(par1, par2, par3);
            return true;
        }
        return false;
    }

    @Override
    public void setVisible(boolean visible) {
        this.guiTextField.setVisible(visible);
        this.guiTextField.setEnabled(visible);
    }

    public void setTextByValue() {
        String text = ((IStringValue)this.config).getStringValue();
        if (((ConfigBase)this.config).getType() == ConfigType.DOUBLE && text.length() > 11) {
            double doubleValue = ((ConfigDouble)this.config).getDoubleValue();
            text = String.format("%e", doubleValue);
        }
        this.guiTextField.setText(text);
    }

    public void drawBox(int i, int j) {
        if (this.guiTextField.getVisible()) {
            this.guiTextField.drawTextBox();
        }
        int xPos = this.guiTextField.xPos;
        int yPos = this.guiTextField.yPos;
        this.mouseOver = i >= xPos && i < xPos + this.guiTextField.width && j >= yPos && j < yPos + this.guiTextField.height;
    }

    @Override
    public void setComment(String comment) {
        ManyLib.logger.warn("InputBox: do not set comment for me");
    }

    @Override
    @Nullable
    public String getComment() {
        return this.config.getConfigGuiDisplayComment();
    }

    @Override
    public boolean shouldDrawComment() {
        return this.mouseOver && this.guiTextField.getVisible();
    }

    public void setValueByText() {
        String text = this.guiTextField.getText();
        ((IStringRepresentable)this.config).setValueFromString(text);
        this.setTextByValue();
    }
}

