/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu233.autobackup.thread;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.ChatMessageComponent;
import net.minecraft.EnumChatFormatting;
import net.minecraft.server.MinecraftServer;

public class BackupThread
extends Thread {
    private static BackupThread INSTANCE;
    private static boolean isRunning;
    private final MinecraftServer server;
    private File worldFile;
    private static final File backupFolder;
    private static final String backupFolderStr;
    private static final DateFormat format;
    private static long delay;

    public BackupThread(File worldFile, MinecraftServer server) {
        this.setName("Backup Thread|\u5907\u4efd\u7ebf\u7a0b");
        this.worldFile = worldFile;
        this.server = server;
        File file = new File("BackupDelay.cfg");
        try {
            if (!file.exists()) {
                if (file.createNewFile()) {
                    FileWriter writer = new FileWriter(file);
                    writer.write(String.valueOf(delay));
                    writer.close();
                } else {
                    server.getLogAgent().logSevere("\u65e0\u6cd5\u521b\u5efa\u5907\u4efd\u95f4\u9694\u65f6\u95f4\u914d\u7f6e\u6587\u4ef6");
                }
            } else {
                Scanner scanner = new Scanner(new FileInputStream(file));
                String time = "";
                if (scanner.hasNextLine()) {
                    time = scanner.nextLine();
                    server.getLogAgent().logInfo("\u5df2\u5c06\u81ea\u52a8\u5907\u4efd\u65f6\u95f4\u8bbe\u7f6e\u4e3a" + time + "ms");
                }
                scanner.close();
                if (!time.equals("")) {
                    try {
                        delay = Long.parseLong(time);
                    }
                    catch (NumberFormatException e) {
                        server.getLogAgent().logSevereException("\u65e0\u6cd5\u83b7\u53d6\u5907\u4efd\u65f6\u95f4\u95f4\u9694,\u5c06\u5907\u4efd\u65f6\u95f4\u95f4\u9694\u8bbe\u4e3a\u9ed8\u8ba4\u503c(30\u5206\u949f)", (Throwable)e);
                        delay = 1800000L;
                    }
                }
            }
        }
        catch (IOException e2) {
            server.getLogAgent().logSevereException("\u65e0\u6cd5\u83b7\u53d6\u5907\u4efd\u65f6\u95f4\u95f4\u9694,\u5c06\u5907\u4efd\u65f6\u95f4\u95f4\u9694\u8bbe\u4e3a\u9ed8\u8ba4\u503c(30\u5206\u949f)", (Throwable)e2);
            delay = 1800000L;
        }
    }

    private static void compress(File sourceFile, ZipOutputStream zos, String name, boolean KeepDirStructure) throws Exception {
        byte[] buf = new byte[1024];
        if (sourceFile.isFile()) {
            int len;
            zos.putNextEntry(new ZipEntry(name));
            FileInputStream in = new FileInputStream(sourceFile);
            while ((len = in.read(buf)) != -1) {
                zos.write(buf, 0, len);
            }
            zos.closeEntry();
            in.close();
            return;
        }
        File[] listFiles = sourceFile.listFiles();
        if (listFiles == null || listFiles.length == 0) {
            if (KeepDirStructure) {
                zos.putNextEntry(new ZipEntry(name + "/"));
                zos.closeEntry();
                return;
            }
            return;
        }
        for (File file : listFiles) {
            if (KeepDirStructure) {
                BackupThread.compress(file, zos, name + "/" + file.getName(), KeepDirStructure);
                continue;
            }
            BackupThread.compress(file, zos, file.getName(), KeepDirStructure);
        }
    }

    public static void setWorldDir(String dir, MinecraftServer server) {
        if (!isRunning) {
            INSTANCE = new BackupThread(new File(dir), server);
            INSTANCE.start();
            return;
        }
        INSTANCE.setWorldFile(new File(dir));
    }

    public static void toZip(File srcDir, OutputStream out, boolean KeepDirStructure) throws RuntimeException {
        ZipOutputStream zos = null;
        try {
            try {
                zos = new ZipOutputStream(out);
                BackupThread.compress(srcDir, zos, srcDir.getName(), KeepDirStructure);
                if (zos != null) {
                    try {
                        zos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e2) {
                throw new RuntimeException("zip error from ZipUtils", e2);
            }
        }
        catch (Throwable th) {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
            throw th;
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    if (!backupFolder.exists()) {
                        backupFolder.mkdir();
                    }
                    long start = System.currentTimeMillis();
                    BackupThread.toZip(this.worldFile, new FileOutputStream(backupFolderStr + "//" + this.worldFile.getName() + "_" + format.format(new Date()) + ".zip"), true);
                    long end = System.currentTimeMillis();
                    long took = end - start;
                    this.server.getLogAgent().logInfo("\u4e16\u754c " + this.worldFile.getName() + " \u538b\u7f29\u5907\u4efd\u5b8c\u6210\uff0c\u8017\u65f6\uff1a" + took + " ms");
                    this.sendChatMsgToAllPlayers(ChatMessageComponent.createFromText((String)("\u670d\u52a1\u7aef\u5b58\u6863\u5907\u4efd\u5b8c\u6210!\u8017\u65f6:" + took + "ms")));
                    isRunning = true;
                    Thread.sleep(Math.max(delay - 10000L, 10000L));
                    this.sendChatMsgToAllPlayers(ChatMessageComponent.createFromText((String)"\u5c06\u572810\u79d2\u540e\u5f00\u59cb\u5907\u4efd\u5b58\u6863!\u53ef\u80fd\u4f1a\u6709\u4e9b\u8bb8\u5361\u987f").setColor(EnumChatFormatting.values()[6]));
                    Thread.sleep(10000L);
                    this.sendChatMsgToAllPlayers(ChatMessageComponent.createFromText((String)"\u670d\u52a1\u5668\u5f00\u59cb\u5907\u4efd...").setColor(EnumChatFormatting.DARK_GREEN));
                }
            }
            catch (FileNotFoundException | InterruptedException | NullPointerException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void sendChatMsgToAllPlayers(ChatMessageComponent msg) {
        this.server.getConfigurationManager().sendChatMsg(ChatMessageComponent.createFromText((String)"[Server] ").appendComponent(msg));
    }

    private void setWorldFile(File file) {
        this.worldFile = file;
    }

    static {
        backupFolder = new File("backup");
        backupFolderStr = new File("backup").getAbsolutePath();
        format = new SimpleDateFormat("yyyy-MM-dd_hh-mm-ss");
        delay = 1800000L;
    }
}

